local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
	Asset( "ANIM", "anim/shadow_hands.zip" ),
	Asset( "SOUND", "sound/sfx.fsb" ),
	Asset( "SOUND", "sound/willow.fsb" ),
	Asset( "ANIM", "anim/beard.zip" ),

	-- Don't forget to include your character's custom assets!
	Asset( "ANIM", "anim/ornie.zip" ),
}

local prefabs = {}

local function SetSpeedBasedOnHunger(inst)
	inst.components.locomotor.walkspeed = (inst.components.hunger.current * 0.025 +(TUNING.WILSON_WALK_SPEED * 0.5))
	inst.components.locomotor.runspeed = (inst.components.hunger.current * 0.025 +(TUNING.WILSON_RUN_SPEED * 0.5))
end

local fn = function(inst)
	--speech sound and map icon
	inst.soundsname = "wolfgang"
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	--Stats
	inst.Transform:SetScale(1.9, 1.9, 1.9)
	inst.components.health:SetMaxHealth(400)
	inst.components.hunger:SetMax(300)
	inst.components.sanity:SetMax(200)
	inst.components.combat.damagemultiplier = 1.5

	inst:ListenForEvent("hungerdelta", SetSpeedBasedOnHunger)

	--Sanity FX
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.8 )
end

STRINGS.CHARACTER_TITLES.ornie = "The Alien Bird Thing"
STRINGS.CHARACTER_NAMES.ornie = "Ornie"
STRINGS.CHARACTER_DESCRIPTIONS.ornie = "*Big and strong, needs more food.\n*Faster on a full stomach.\n*Slower on an empty stomach."
STRINGS.CHARACTER_QUOTES.ornie = "\" Giddy up!\""
STRINGS.CHARACTERS.ORNIE = require "speech_ornie"

return MakePlayerCharacter("ornie", prefabs, assets, fn)